(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
        typeof define === 'function' && define.amd ? define(factory) :
            (window.slideVerifyPlug = factory());
}(this, (function () { 'use strict';

    var SlideVerify = function (ele, opt) {
        this.$ele = document.querySelector(ele);
        // 默认参数
        this.defaults = {
            initText: '请按住滑块，拖动到最右边',
            sucessText: '验证通过',
            getSuccessState: function () {}
        }

        this.settings = Object.assign({}, this.defaults, opt);
        this.touchX = 0;
        this.slideFinishState = false;
        this.init();
    }

    SlideVerify.prototype = {
        constructor: SlideVerify,
        init: function () {
            this.initDom();
            this.initStyle();
            this.initEle();
            this._mousedown();
            this._mouseup();
            this._touchstart();
            this._touchmove();
            this._touchend();
        },
        initDom: function () {
            var html = `
                <div class="drag-progress dragProgress"></div>
                <span class="drag-btn dragBtn"></span>
                <span class="fix-tips fixTips">${this.settings.initText}</span>
                <span class="verify-msg sucMsg">${this.settings.sucessText}</span>
            `;
            this.$ele.innerHTML += html;
        },
        initStyle: function () {
            if (this.settings.wrapWidth) {
                this.$ele.style.width = this.settings.wrapWidth + 'px';
            } else {
                this.$ele.style.width = '100%';
            }
        },
        initEle: function () {
            this.slideBtn = this.$ele.querySelector('.dragBtn');
            this.slideProEle = this.$ele.querySelector('.dragProgress');
            this.slideSucMsgEle = this.$ele.querySelector('.sucMsg');
            this.slideFixTipsEle = this.$ele.querySelector('.fixTips');
            this.maxSlideWid = this.calSlideWidth();
        },
        _mousedown: function () {
            var _this = this;
            var ifThisMousedown = false;
            this.slideBtn.addEventListener('mousedown', function (e) {
                var distenceX = e.pageX;
                e.preventDefault();
                if (_this.slideFinishState || _this.ifAnimated()) {
                    return false;
                }
                ifThisMousedown = true;

                document.addEventListener('mousemove', function (e) {
                    if (!ifThisMousedown) {
                        return false;
                    }
                    var curX = e.pageX - distenceX;
                    if (curX >= _this.maxSlideWid) {
                        _this.setDragBtnSty(_this.maxSlideWid);
                        _this.setDragProgressSty(_this.maxSlideWid);
                        _this.cancelMouseMove();
                        _this.slideFinishState = true;
                        if (_this.settings.getSuccessState) {
                            _this.settings.getSuccessState(_this.slideFinishState);
                        }
                        _this.successSty();
                    } else if (curX <= 0) {
                        _this.setDragBtnSty('0');
                        _this.setDragProgressSty('0');
                    } else {
                        _this.setDragBtnSty(curX);
                        _this.setDragProgressSty(curX);
                    }
                });

                document.addEventListener('mouseup', function () {
                    if (!ifThisMousedown) {
                        return false;
                    }
                    ifThisMousedown = false;
                    if (_this.slideFinishState) {
                        _this.cancelMouseMove();
                        return false;
                    } else {
                        _this.failAnimate();
                        _this.cancelMouseMove();
                    }
                });
            });
        },
        _mouseup: function () {},
        _touchstart: function () {
            var _this = this;
            this.slideBtn.addEventListener('touchstart', function (e) {
                _this.touchX = e.touches[0].pageX;
                if (_this.slideFinishState || _this.ifAnimated()) {
                    return false;
                }
            });
        },
        _touchmove: function () {
            var _this = this;
            this.slideBtn.addEventListener('touchmove', function (e) {
                e.preventDefault();
                var curX = e.touches[0].pageX - _this.touchX;
                if (curX >= _this.maxSlideWid) {
                    _this.setDragBtnSty(_this.maxSlideWid);
                    _this.setDragProgressSty(_this.maxSlideWid);
                    _this.cancelTouchmove();
                    _this.successSty();
                    _this.slideFinishState = true;
                    if (_this.settings.getSuccessState) {
                        _this.settings.getSuccessState(_this.slideFinishState);
                    }
                    _this.slideFinishState = true;
                } else if (curX <= 0) {
                    _this.setDragBtnSty('0');
                    _this.setDragProgressSty('0');
                } else {
                    _this.setDragBtnSty(curX);
                    _this.setDragProgressSty(curX);
                }
            });
        },
        _touchend: function () {
            var _this = this;
            this.slideBtn.addEventListener('touchend', function () {
                if (_this.slideFinishState) {
                    _this.cancelTouchmove();
                    return false;
                } else {
                    _this.failAnimate();
                }
            });
        },
        getDragBtnWid: function () {
            return parseInt(this.slideBtn.offsetWidth);
        },
        getDragWrapWid: function () {
            return parseFloat(this.$ele.offsetWidth);
        },
        calSlideWidth: function () {
            var _this = this;
            return _this.getDragWrapWid() - _this.getDragBtnWid();
        },
        ifAnimated: function () {
            return this.slideBtn.style.transition !== '';
        },
        getDragBtnLeft: function () {
            return this.slideBtn.style.left;
        },
        ifSlideRight: function () {
            var _this = this;
            return parseInt(_this.getDragBtnLeft()) === parseInt(_this.calSlideWidth());
        },
        setDragBtnSty: function (left) {
            this.slideBtn.style.left = left + 'px';
        },
        setDragProgressSty: function (wid) {
            this.slideProEle.style.width = wid + 'px';
        },
        cancelMouseMove: function () {
            document.removeEventListener('mousemove', this._mousemove);
        },
        cancelTouchmove: function () {
            this.slideBtn.removeEventListener('touchmove', this._touchmove);
        },
        successSty: function () {
            this.slideSucMsgEle.style.display = 'block';
            this.slideBtn.classList.add('suc-drag-btn');
        },
        failAnimate: function () {
            this.slideBtn.style.transition = 'left 0.2s';
            this.slideBtn.style.left = '-1px';
            this.slideProEle.style.transition = 'width 0.2s';
            this.slideProEle.style.width = '0';
        },
        resetVerify: function () {
            this.slideSucMsgEle.style.display = 'none';
            this.slideBtn.classList.remove('suc-drag-btn');
            this.slideFinishState = false;
            this.slideProEle.style.width = '0';
            this.slideBtn.style.left = '-1px';
            this._touchmove();
        }
    };

    var inlineCss = '*{box-sizing:border-box}.verify-wrap{width:200px;border-radius: 5px;height:30px;background-color:#e5e5e5;margin:5px auto;position:relative}.verify-wrap .drag-btn{border-radius: 5px;position:absolute;left:0px;top:0px;width:42px;height:30px;background:#fff url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACoAAAAiCAYAAAApkEs2AAAA/UlEQVRYhe3XLc9GYBjG8eN6dkdFIQuqoCiCbj6ob2CCIplRaJKqEHT3c/kAz66Xc/fLnvO3UY7N/jNmxDAMF77AQ57iOH53x5/GccTPuyNUcSg1DqXGodQ4lNr/CC3LEsuyaG8mrEKzLEPXdZjnWWszYRXq+z7yPMc0Tej7XnkzYf2Muq6LoiiwrivatsV1XUrby0Mlx3Huu7fvO5qmUd50kL31QgijTdXD+gq/zvNEVVXwPA9pmipvOqxDj+O4Q4IgQJIkypsuq9Bt21DXNaIoug/VzYRVqHw55J0Kw1BrMyHkXyj/3BHiUGocSo1DqXEota8Jvb/18hP16Z7qL3h/w53n4AAAAABJRU5ErkJggg==) no-repeat center center;background-size:100% 100%;z-index:2;cursor:move;}.verify-wrap .suc-drag-btn{background:#fff url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACoAAAAiCAYAAAApkEs2AAACA0lEQVRYhe2Y2yuDYRzHv7PJYc5zKspYSRMymStXu5NCs5W4csEfwJ+gSA53csg1F4R/gSu0OcWSmNIQkfMcEvu9tdpY79793leo91Nbbft993x6nj2/52kal8v1gX+Ajp4sFstve4jidrsR99sSUlFFlUYVVRpVVGl0SnyJ934VaxczOLpdwd3bufBeWnw+StLrYc1tQ3FqnewxZIk+vz9g7rAHO9dL3z67efXBfTkrPCqymtBqGkaiNoU9FnvpSXJyzx5R8itUQ7WU4cIWnT/qhe9xS3I91VKGC0uUfpPbV4uSajUhQ1CGshxYorRxpGDObECf1Ysm40DM2a+wNhPt7mhUZzvhMI1Aq9HBkFgUUzYSrBkNtiDCkGBES/Eg8pLKwiSdplFB8uRhEzMH3RGzsSC7j9oKe1CT4wi0oEZMeRzITy4XJOM0WkFy2uOE//1O7jA8UWrm1CeJ5dMxlGXYoI/PQrd5AQlavagkZTmwlt4UOHGCnPs9wkw+vl0jSZcWdSZDsz8uas1tD3t99rSL8b0W3Lz4cHy/LrrctYEjlQNr6Y2ptag0NIf10gv/Pvo3akRzlOGe++yTyV4yhAJ9leR6qqUMF7YoXTC6zPPChSMaVEO1ci4lstoTDdxROhE4Fjv/9jUvCIkoISPGv7nhq6JKo4oqjSqqNEIfpf8f/zqf+36643RPeo8AAAAASUVORK5CYII=) no-repeat center center;background-size:100% 100%}.verify-wrap .drag-progress{border-radius: 5px 0 0 5px;position:absolute;left:0;top:0px;height:30px;width:0;background-color:#7ac23c;color:#fff;font-size:18px;text-align:center;line-height:30px}.verify-wrap .fix-tips,.verify-msg{width:100%;position:absolute;right:0;left:0px;height:100%;color:#51555c;z-index:1;line-height:30px;font-size:12px;text-align:center}.verify-wrap .verify-msg{border-radius: 5px;background-color:#7ac23c;color:#fff;display:none}';
    var styleObj = document.createElement('style');
    styleObj.type = 'text/css';
    styleObj.innerHTML = inlineCss;
    document.head.appendChild(styleObj);

    return SlideVerify;

})));