<?php
error_reporting(0);
ini_set('memory_limit', '1024M');   // 防止内存溢出
set_time_limit(0);
date_default_timezone_set('Asia/Shanghai');

/*
=========================================================
🚀 玉兔CMS 视频搜索系统（懒加载 + 自动刷新 + 轻索引仅标题）
兼容 PHP 5.3 ~ PHP 8.x
作者: ChatGPT 优化版 2025.10
=========================================================
*/

$cache_dir  = './cache/search/';
$full_file  = $cache_dir . 'name_index.json';   // 全字段缓存
$light_file = $cache_dir . 'name_search.json';  // 轻索引，仅 d_name
$lock_file  = $cache_dir . 'refresh.lock';

// =====================================================
// 1️⃣ 每天 00:30 以后首次访问：删除旧缓存并写入锁文件（北京时间）
// =====================================================
if (!is_dir($cache_dir)) @mkdir($cache_dir, 0777, true);

$today        = date('Ymd');
$nowHM        = date('H:i');
$last_refresh = is_file($lock_file) ? trim(@file_get_contents($lock_file)) : '';

if ($nowHM >= '00:30' && $last_refresh !== $today) {
    @unlink($full_file);
    @unlink($light_file);
    @file_put_contents($lock_file, $today);
}

// =====================================================
// 2️⃣ 优先加载轻索引（仅 d_name）
// =====================================================
$index = array();

if (file_exists($light_file)) {
    $json  = file_get_contents($light_file);
    $index = json_decode($json, true);
    if (!is_array($index)) $index = array();
}

// =====================================================
// 3️⃣ 若缓存不存在或损坏则自动重建
// =====================================================
if (empty($index) || !file_exists($full_file)) {
    // 自动查找根目录（最多上溯9层）
    $root = __DIR__;
    $found = false;
    for ($i = 0; $i < 9; $i++) {
        if (is_dir($root . '/JCSQL/Home')) { $found = true; break; }
        $root = dirname($root);
    }
    $data_dir = $found ? ($root . '/JCSQL/Home/') : './JCSQL/Home/';

    $uubb  = array();
    $index = array();

    for ($x = 1; $x <= 32; $x++) {
        $file_path = $data_dir . $x . '.txt';
        if (!is_file($file_path)) continue;

        $data = json_decode(file_get_contents($file_path), true);
        if (!is_array($data)) continue;

        foreach ($data as $v) {
            $uubb[] = $v;
            $text = isset($v['d_name']) ? $v['d_name'] : '';
            $index[] = array('text' => $text);
        }
    }

    // 写入双缓存文件
    @file_put_contents($full_file,  json_encode($uubb,  JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
    @file_put_contents($light_file, json_encode($index, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

    @file_put_contents($cache_dir . 'refresh.log',
        date('Y-m-d H:i:s') . " 自动重建缓存，共 " . count($uubb) . " 条数据\n", FILE_APPEND);

    unset($uubb); // 释放内存
}

// =====================================================
// 4️⃣ 安全过滤函数
// =====================================================
if (!function_exists('clean_xss')) {
    function clean_xss($str, $trim = false) {
        if ($trim) $str = trim($str);
        return htmlspecialchars(strip_tags($str), ENT_QUOTES, 'UTF-8');
    }
}

$GetMb_id   = isset($GetMb_id) ? clean_xss($GetMb_id, true) : '';
$GetMb_page = isset($GetMb_page) ? intval($GetMb_page) : 1;

// =====================================================
// 5️⃣ 高速懒加载搜索逻辑（仅标题）
// =====================================================
function search_lazy($index_file, $full_file, $keyword)
{
    $result = array();
    if ($keyword === '' || !file_exists($index_file) || !file_exists($full_file)) return $result;

    $index = json_decode(file_get_contents($index_file), true);
    if (!is_array($index)) return $result;

    $pattern = '/' . preg_quote($keyword, '/') . '/i';
    $match_ids = array();

    // 第一阶段：快速匹配轻索引
    foreach ($index as $i => $row) {
        if (!empty($row['text']) && preg_match($pattern, $row['text'])) {
            $match_ids[] = $i;
        }
    }

    // 第二阶段：仅加载匹配部分的完整数据
    if (!empty($match_ids)) {
        $json = file_get_contents($full_file);
        $all  = json_decode($json, true);
        if (is_array($all)) {
            foreach ($match_ids as $id) {
                if (isset($all[$id])) $result[] = $all[$id];
            }
        }
        unset($all);
    }

    return $result;
}

// 执行懒加载搜索
$MYSQLVODS = search_lazy($light_file, $full_file, $GetMb_id);

// =====================================================
// 6️⃣ 无结果提示
// =====================================================
if (empty($MYSQLVODS)) {
    $safe_kw = addslashes($GetMb_id);
    echo '<script>alert("抱歉！无 ' . $safe_kw . ' 搜索结果！点击确定返回首页！");window.location.href="?";</script>';
    exit();
}

// =====================================================
// 7️⃣ 输出模板变量
// =====================================================
$count = count($MYSQLVODS) - 1;
$tpl->assign('SearchTypeJCSQL', $MYSQLVODS);
$tpl->assign('SearchTypePage', $GetMb_page);
$tpl->assign('SearchTypeId', $GetMb_id);
$tpl->assign('SearchTypeName', $GetMb_id);

$tpl->show($this_WebMoban . '/html/' . $GetMb_tmp);
?>
